<?php

define('ONETAKE_OPTIONS_PREFIXED' ,'onetake_');
/*
 * Loads the Options Panel
 *
 * If you're loading from a child theme use stylesheet_directory
 * instead of template_directory
 */

define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/admin/' );
require_once dirname( __FILE__ ) . '/admin/options-framework.php';
require_once get_template_directory() . '/options.php';

/*
 * This is an example of how to add custom scripts to the options panel.
 * This one shows/hides the an option when a checkbox is clicked.
 *
 * You can delete it if you not using that option
 */
add_action( 'optionsframework_custom_scripts', 'optionsframework_custom_scripts' );

function optionsframework_custom_scripts() { 
}

/*
 * This is an example of filtering menu parameters
 */

/*
function prefix_options_menu_filter( $menu ) {
	$menu['mode'] = 'menu';
	$menu['page_title'] = __( 'Hello Options', 'onetake');
	$menu['menu_title'] = __( 'Hello Options', 'onetake');
	$menu['menu_slug'] = 'hello-options';
	return $menu;
}

add_filter( 'optionsframework_menu', 'prefix_options_menu_filter' );
*/



/**
 * Theme setup
 */
 
load_template( trailingslashit( get_template_directory() ) . 'includes/theme-setup.php' );

/**
 * Theme functions
 */
 
load_template( trailingslashit( get_template_directory() ) . 'includes/custom-functions.php' );

/**
 * Theme widgets
 */
 
load_template( trailingslashit( get_template_directory() ) . 'includes/theme-widgets.php' );

/**
 * Theme breadcrumb
 */
 
load_template( trailingslashit( get_template_directory() ) . 'includes/breadcrumb-trail.php' );

/**
 * Mobile Detect Library
 */
 
if( !class_exists("Mobile_Detect") ) 
load_template( trailingslashit( get_template_directory() ) . 'includes/Mobile_Detect.php' );

 	/*	
	*	get background 
	*	---------------------------------------------------------------------
	*/
function onetake_get_background($args){
$background = "";
 if (is_array($args)) {
	if (isset($args['image']) && $args['image']!="") {
	$background =  "background:url(".esc_url($args['image']). ")  ".esc_attr($args['repeat'])." ".esc_attr($args['position'])." ".esc_attr($args['attachment']).";";
	}
	else
	{
	if(isset($args['color']) && $args['color'] !=""){
	$background = "background:".esc_attr($args['color']).";";
	}
	}
	}
return $background;
}
